<?php
require("core.php");
head();

if (isset($_POST['save-settings'])) {
    $scandir     = htmlspecialchars(strip_tags($_POST['scandir']));
    $extensions  = htmlspecialchars(strip_tags($_POST['extensions']));
    $ignored     = htmlspecialchars(strip_tags($_POST['ignored']));
	$add_strings = addslashes($_POST['additional_strings']);
    
    $config['scan-dir']           = $scandir;
    $config['file-extensions']    = $extensions;
    $config['ignored-dirs']       = $ignored;
	$config['additional-strings'] = $add_strings;
    file_put_contents('config.php', '<?php return ' . var_export($config, true) . '; ?>');
}

if (isset($_GET['ignore'])) {
    $fileign = $_GET['ignore'];
    $ignored = $config['ignored-dirs'] . "|" . $fileign;
    
    $config['ignored-dirs'] = $ignored;
    file_put_contents('config.php', '<?php return ' . var_export($config, true) . '; ?>');
	
	echo '<meta http-equiv="refresh" content="0; url=malware-scanner.php" />';
}
?>
<div class="content-wrapper">

			<!--CONTENT CONTAINER-->
			<!--===================================================-->
			<div id="content-container">
				
				<section class="content-header">
    			  <h1><i class="fa fa-search"></i> Malware Scanner</h1>
    			  <ol class="breadcrumb">
   			         <li><a href="dashboard.php"><i class="fa fa-home"></i> Admin Panel</a></li>
    			     <li class="active">Malware Scanner</li>
    			  </ol>
    			</section>


				<!--Page content-->
				<!--===================================================-->
				<section class="content">

                <div class="row">
				<div class="col-md-12">
				    <div class="box">
						<div class="box-header">
							<h3 class="box-title">Malware Scanner</h3>
						</div>
						<div class="box-body">

<div class="col-md-12">
<div class="callout callout-info">
<p>
    There is a chance of false-positive results, please analyze the results and verify them. Sometimes the scanning process could take more time according to the files on your host.
</p>
</div>
</div>
                                    
                                    
					<center>
					<a href="?normal_scan" class="btn btn-flat btn-primary" title="The normal scan scans all files with the simple scan engine"><i class="fa fa-search"></i> Run Normal Scan</a> 
					<a href="?deep_scan" class="btn btn-flat btn-danger" title="The deep scan scans all files with the heaviest scan engine, but could show many false-positive threats."><i class="fa fa-search"></i> Run Deep Scan</a> 
                    <button data-target="#settings" data-toggle="modal" class="mb-xs mt-xs mr-xs modal-with-zoom-anim btn btn-flat btn-default"><i class="fa fa-cogs"></i> Settings</button>
					</center><br />
                                    
<div class="modal fade" id="settings" role="dialog" tabindex="-1" aria-labelledby="settings" aria-hidden="true">
        <div class="modal-dialog">
			<div class="modal-content">

				<div class="modal-header">
					<button data-dismiss="modal" class="close" type="button">
					<span aria-hidden="true">&times;</span>
					</button>
					<h4 class="modal-title"><i class="fas fa-cog"></i> Settings</h4>
				</div>

                <form action="" method="post">
				<div class="modal-body">                           
                                  <div class="row"> 
                                      <div class="col-md-12">
                                            <div class="form-group">
                                                        
                                                        <label class="col-sm-3">Scan Directory: </label>
														<div class="col-sm-9">
															<input type="text" name="scandir" class="form-control" value="<?php
echo $config['scan-dir'];
?>" /><br />
														</div>
                                                        
                                                        <label class="col-sm-3">File Extensions Scanned:</label>
														<div class="col-sm-9">
                                                            <textarea class="form-control" name="extensions" rows="2"><?php
echo $config['file-extensions'];
?></textarea>
                                                            (Separate the file extensions with <strong>"|"</strong>)<br /><br />
														</div>
                                                        
                                                        <label class="col-sm-3">Ignored directories and files: </label>
														<div class="col-sm-9">
															<textarea class="form-control" name="ignored" rows="4"><?php
echo $config['ignored-dirs'];
?></textarea>
                                                            (Separate the ignored directories and files with <strong>"|"</strong>)<br /><br />
														</div>
														
														<label class="col-sm-3">Additional scan strings: </label>
														<div class="col-sm-9">
															<textarea class="form-control" name="additional_strings" rows="4" placeholder="Example: iframe|bruteforce|ddos"><?php
echo $config['additional-strings'];
?></textarea>
                                                            (Strings that will be searched in the files. Separate them with <strong>"|"</strong>)<br /><br />
														</div>
                                                            
                                              </div>
                                        </div>
                                   </div>
				</div>
        
                <div class="modal-footer">
					<input type="submit" name="save-settings" class="btn btn-flat btn-primary btn-block" value="Save" />
				</div>

                </form>
            </div>
    </div>
</div>

<?php
@set_time_limit(360);
ini_set('max_execution_time', 300); //300 Seconds = 5 Minutes
ini_set('memory_limit', '512M');

$fileExt     = $config['file-extensions']; // File extensions
$ignoreDirs  = $config['ignored-dirs']; // Directories & Files to ignore
$directory   = $config['scan-dir']; // Directory to scan
$scanstrings = $config['additional-strings']; // Directory to scan

// Remove first '|' from ignored dirs
if($ignoreDirs[0] == '|') {
  $ignoreDirs = ltrim($ignoreDirs, $ignoreDirs[0]); 
}
// Remove last '|' from ignored dirs
if(substr($ignoreDirs, -1) == '|') {
  $ignoreDirs = substr($ignoreDirs, 0, -1);
}

// Remove first '|' from directory
if($directory[0] == '|') {
  $directory = ltrim($directory, $directory[0]); 
}
// Remove last '|' from directory
if(substr($directory, -1) == '|') {
  $directory = substr($directory, 0, -1);
}

if ($scanstrings != '') {
  // Remove first '|' from scan strings
  if($scanstrings[0] == '|') {
	$scanstrings = ltrim($scanstrings, $scanstrings[0]); 
  }
  // Remove last '|' from scan strings
  if(substr($scanstrings, -1) == '|') {
	$scanstrings = substr($scanstrings, 0, -1);
  }
}

if (isset($_GET['normal_scan']) || isset($_GET['deep_scan'])) {

$count         = 0;
$total_results = 0;

function HumanReadableFilesize($file)
{
    $size  = filesize($file);
    $mod   = 1024;
    $units = explode(' ', 'B KB MB GB TB PB');
    for ($i = 0; $size > $mod; $i++) {
        $size /= $mod;
    }
    return round($size, 2) . ' ' . $units[$i];
}

$Strings = 'r0nin|m0rtix|iskorpitx|upl0ad|r57shell|c99shell|shellbot|phpshell|void\.ru|phpremoteview|directmail|bash_history|cwings|vandal|bitchx|eggdrop|guardservices|psybnc|dalnet|undernet|vulnscan|spymeta|raslan58|Webshell|str_rot13|FilesMan|FilesTools|Web Shell|bckdrprm|hackmeplz|wrgggthhd|WSOsetcookie|Hmei7|Inbox Mass Mailer|HackTeam|Hackeado|Janissaries|Miyachung|ccteam|Adminer|OOO000000|$GLOBALS|findsysfolder|makeret.ru|c0d3d by|C0de For|Perl Auto Rooter Perl Script|create_function|b374k|Web Shell by boff|Web Shell by oRb|devilzShell|Shell by Mawar_Hitam|N3tshell|Storm7Shell|Locus7Shell|private Shell by m4rco|w4ck1ng shell|blackhat Shell|FaTaLisTiCz_Fx Fx29Sh|th3w1tch Shell|Goog1e_analistRCBot|Antihutan|Attijari|ByroeNet|cpftpcrack|KAdot|MulCiShell|PHPJackal|POSTpe80|SRCrew|Safe0ver|SimShell|Storm7|Surrogafier|TuR334Vl|UberCracker|Vrs-hCk|Cyb3rDevils|DxShell|DataCha0s|Forever2008|InsideTeam|ItsmYarD|aKpuMPiN|Xnuxer|cgitelnet|ShellHook|Perlovga|Mirccrack|CookStealer|Bypassshell|r00t3r|zerocnbct|Ylyshell|egyspider|evilc0der|violaoeucc0101|iTSecTeam|putr4XtReme|aZRaiL|cbLorD|91.239.15.61|_YM82iAN|XXRANDOMXX|_POST..n13e558|envir0nn@yahoo.com|$bogel|c999sh_surl|xVebaPURjEzLc|AQSP|ANTIPIDERSIA|uzanc|xadpritox|blackboy007|nacomb13|Devilzc0de|8a4bf282852bf4c49e17f0951f645e72|k2ll33d|tsxpwkpqbk|HackerBooty|JE8wMDBPME8wMD1mb3BlbigkT09PME8w|Rawckerhead|sPMQhNQMR9XM05Cvsbg1DTE5vRJiEnn|UnixCrew|HolaKo|4xI0DHgMAmwFstDDeTdg26|fb0979fa651bb915d186ac0fddcd1bc6|fb621f5060b9f65acf8eb4232e3024140dea2b34|xunzhaocangjingkong|123321|WwW.7jyewu.Cn|zbazszez64z_zdeczodze|nr9Sb1ehwpGJoIkcy5LEUxtRVxEzGglYpr5xIy|HaniXavi|k_i@outlook.com|hanikadi0@gmail.com|naruto@localhost.com|JSUlJSUlJbEk9J3NldF90aW1lX2xpbWl0Jzs|Dz93hR3fWlPVRtrH2txMf+DrmGvyq4tsaa|IRCBot|Locus7s|c100 Shell|Project x2300|Captain Crunch Team|Shadow & Preddy|w4ck1ng|milw0rm|Rootshell.c|Snailsor,FuYu,BloodSword,Cnqing|ASPXSpy|Iranian Hackers|Hossein Asgary|SimAttacker|simorgh-ev|BuqX@HotMail.Com|GrayHatz Hacking|Kacak FSO|grayhatz.org|TurkGuvenligi|r57.biz|evalinfect|1dt.w0lf|http://ghc.ru|evilc0der.com';
$DeepScanStrings = 'zlib_decode|zlib_encode|gzget|gzpassthru|lzw_decompress|passthru|shell_exec|proc_|popen|proc_open|edoced_46esab';
if ($scanstrings != '') {
  $Strings .= '|' . $scanstrings;
}

$Patterns = array(
    array(
        'preg_replace\s*\(\s*[\"\']\s*(\W)(?-s).*\1[imsxADSUXJu\s]*e[imsxADSUXJu\s]*[\"\'].*\)', // [0] = RegEx search pattern
        'PHP: preg_replace Eval', // [1] = Name / Title
        'Detected preg_replace function that evaluates (executes) matched code. ' . 'This means if PHP code is passed it will be executed.', // [2] = description
        'Part example code from http://sucuri.net/malware/backdoor-phppreg_replaceeval'
    ), // [3] = More Information link
    array(
        'c999*sh_surl',
        'Backdoor: PHP:C99',
        'Detected the "C99 Shell"? Backdoor that allows attackers to manage (and ' . 'reinfect) your website remotely. It is often used as part of a ' . 'compromise to maintain access to the hacked sites.',
        'http://sucuri.net/malware/backdoor-phpc99045'
    ),
    array(
        'preg_match\s*\(\s*\"\s*/\s*bot\s*/\s*\"',
        'Backdoor: PHP:R57',
        'Detected the "R57 Shell"? Backdoor that allows attackers to access, modify and ' . 'reinfect your site. It is often hidden in the filesystem and hard to ' . 'find without access to the server or logs.',
        'http://sucuri.net/malware/backdoor-phpr5701'
    ),
    array(
        'eval[\s/\*\#]*\(stripslashes[\s/\*\#]*\([\s/\*\#]*\$_(REQUEST|POST|GET)\s*\[\s*\\\s*[\'\"]\s*asc\s*\\\s*[\'\"]',
        'Backdoor: PHP:GENERIC',
        'Detected a generic backdoor that allows attackers to upload files, delete ' . 'files, access, modify and/or reinfect your site. It is often hidden ' . 'in the filesystem and hard to find without access to the server or ' . 'logs. It also includes uploadify scripts and similars that offer ' . 'upload options without security. ',
        'http://sucuri.net/malware/backdoor-phpgeneric07'
    ),
    /*array('https?\S{1,63}\.ru',
    'Russian URL',
    'Detected a .RU domain link, as there are many attacks leading the innocent visitors to .RU pages. Maybe it\'s valid link, but leave it to you to check this out.',
    ),*/
    array(
        'preg_replace\s*\(\s*[\"\'\”]\s*/\s*\.\s*\*\s*/\s*e\s*[\"\'\”]\s*,\s*[\"\'\”]\s*\\x65\\x76\\x61\\x6c',
        'Backdoor: PHP:Filesman:02',
        'Detected the “Filesman Shell”? Backdoor that allows attackers to access, modify ' . 'and reinfect your site. It is often hidden in the filesystem and hard ' . 'to find without access to the server or logs.',
        'http://sucuri.net/malware/backdoor-phpfilesman02'
    ),
    array(
        '(include|require)(_once)*\s*[\"\'][\w\W\s/\*]*php://input[\w\W\s/\*]*[\"\']',
        'PHP:\input include',
        'Detected the method of reading input through PHP protocol handler in ' . 'include/require statements.'
    ),
    array(
        'data:;base64',
        'data:;base64 include',
        'Detected the method of executing base64 data in include.'
    ),
    array(
        'RewriteCond\s*%\{HTTP_REFERER\}',
        '.HTACCESS RewriteCond-Referer',
        'Your .htaccess file has a conditional redirection based on "HTTP Referer".' . 'This means it redirects according to site/url from where your visitors ' . 'came to your site. Such technique has been used for unwanted redirections ' . 'after coming from Google or other search engines, so check this directive carefully.'
    ),
    array(
        'jquery.min.php',
        'Fake jQuery Malware',
        'This file is infected with the Fake jQuery Malware. Removing the malware is not enough. Make sure your CMS and all its third-party components are up-to-date. All unused stuff should be ruthlessly deleted from server. Some of the compromised websites had malicious WordPress admin users with names like: backup, dpr19, loginfelix. Some of them had been created during past attacks though.'
    ),
    array(
        'GIF89a.*[\r\n]*.*<\?php',
        'PHP file desguised as GIF image',
        'Detected a PHP file that was most probably uploaded as an image via webform that loosely only checks file headers.'
    ),
    array(
        '\$ip[\w\W\s/\*]*=[\w\W\s/\*]*getenv\(["\']REMOTE_ADDR["\']\);[\w\W\s/\*]*[\r\n]\$message',
        'Probably malicious PHP script that "calls home"',
        'Detected script variations often used to inform the attackers about found vulnerable website.'
    ),
    array(
        '(?:(?:base64_decode|str_rot13)[\s\/\*\w\W\(]*){2,};',
        'Multiple encoded, most probably obfuscated code found',
        'This pattern could be used in highly encoded, malicious code hidden under ' . 'a loop of code obfuscation function calls. In most cases the decoded ' . 'hacker code goes through an eval call to execute it. This pattern is ' . 'also often used for legitimate purposes, e.g. storing configuration ' . 'information or serialised object data. '
    ),
    /*array(
        '<\s*iframe',
        'IFRAME Element',
        'Found IFRAME element in code. It\'s mostly benevolent, but often used ' . 'for bad stuff, so please check if it\'s a valid code.'
    ),*/
    array(
        'strrev[\s/\*\#]*\([\s/\*\#]*[\'"]\s*tressa\s*[\'"]\s*\)',
        'Reversed string "assert"',
        'Assert function name is being hidden behind strrev().'
    ),
    array(
        'is_writable[\s/\*\#]*\([\s/\*\#]*getcwd',
        'Is the current DIR Writable?',
        'This could be harmless, but used in some malware'
    ),
    /*array('(?:\\\\x[0-9A-Fa-f]{1,2}|\\\\[0-7]{1,3}){2,}',
    'At least two characters in hexadecimal or octal notation',
    'Found at least two characters in hexadecimal or octal notation. It '
    . 'doesn\'t mean it is malicious, but it could be code hidding behind '
    . 'such notation.'),*/
    array(
        '\$_F\s*=\s*__FILE__\s*;\s*\$_X\s*=',
        'SourceCop encoded code',
        'Found the SourceCop encoded code. It is often used for malicious code
            hidding, so go and check the code with some online SourceCop decoders'
    ),
    array(
        '(?:passthru|shell_exec|proc_|popen)[\w\W\s/\*]*\([\s/\*\#\'\"\w\W\-\_]*(?:\$_GET|\$_POST|\$_REQUEST)',
        'Shell command execution from POST/GET variables',
        'Found direct shell command execution getting variables from POST/GET,
            which is highly dangerous security flaw or a part of malicious webrootkit'
    ),
    /*array('\$\w[\w\W\s/\*]*=[\w\W\s/\*]*`.*`',
    'PHP execution operator: backticks (``)',
    'PHP execution operator found. Note that these are not single-quotes!
    PHP will attempt to execute the contents of the backticks as a shell
    command, which might indicate a part of a web rootkit'),*/
    array(
        'fsockopen\s*\(\s*[ \'\"](?:localhost|127\.0\.0\.1)[ \'\"]',
        'Opening socket to localhost',
        'Found code opening socket to localhost, it\'s worth investigating more'
    ),
    array(
        'fsockopen\s*\(.*,\s*[ \'\"](?:25|587|465|475|2525)[ \'\"]',
        'Opening socket to known SMTP ports, possible SPAM script',
        'Found opening socket to known SMTP ports, possible SPAM script'
    ),
    array(
        '(?:readfile|popen)\s*\(\s*[ \'\"]*\s*(?:file|http[s]*|ftp[s]*|php|zlib|data|glob|phar|ssh2|rar|ogg|expect|\$POST|\$GET|\$REQUEST)',
        'Reading streams or superglobal variables with fopen wrappers present',
        'Found functions reading data from streams/wrappers - please analyze the code'
    ),
    array(
        'array_(?:diff_ukey|diff_uassoc|intersect_uassoc|udiff_uassoc|udiff_assoc|uintersect_assoc|uintersect_uassoc)\s*\(.*(?:\$_REQUEST|\$_POST|\$_GET).*;',
        'Callback function comming from REQUEST/POST/GET variable possible',
        'Found possible local execution enabling-script receiving data from POST or GET requests'
    ),
    /*array(
    '^(((.*)(=|;)(\s*)?)|((@|\s)*))extract\s*\(',
    'Extract Function',
    'PHP extract function found. Extract creates variables from an array (eg $_POST, $_GET or $_REQUEST). It can be legit, but if there is some strange code execution like $extracted_variable_1($extracted_variable_2) it should be malicious.'
    ),*/
    array(
        '^(((.*)(=|;)(\s*)?)|((@|\s)*))(include|require)(_once)?\s*\(?("|\')https?://',
        'Remote Include',
        'Include or require which includes a remote file. It should be malicious, and vulnerable as well.'
    ),
    array(
        '\\\\x([abcdef0-9]{2}){3,}',
        'Hex Encoded String',
        'Code which is hex encoded. It can be legit, but not a usual thing. Malicious users can hide their functions in hex encoded expressions.'
    )
);

$FileNames = array(
    'Probably an OpenFlashChart library demo file that has known input ' . 'validation error (CVE-2009-4140)' => 'ofc_upload_image.php',
    'Probably an R57 shell' => 'r57.php',
    'Probably a C99 shell' => 'c99.php',
    'Probably a C100 shell' => 'c100.php',
    'PhpInfo() file? It is advisable to remove such file, as it could reveal too
        much info to potential attackers' => 'phpinfo.php',
    'PerlInfo() file? It is advisable to remove such file, as it could reveal too
        much info to potential attackers' => 'perlinfo.php'
);

// check if DeepScan should be done
if (isset($_GET['deep_scan'])) {
    @$patterns = array_merge($Patterns, explode('|', $Strings), explode('|', $DeepScanStrings));
} else {
    @$patterns = array_merge($Patterns, explode('|', $Strings));
}
$ext = explode('|', $fileExt);

function get_filelist($dir)
{
    global $ignoreDirs;
    $ignoreArr = explode('|', $ignoreDirs);
    
    $path      = $dir;
    $toResolve = array(
        $dir
    );
    while ($toResolve) {
        $thisDir = array_pop($toResolve);
        if (@$dirContent = scandir($thisDir)) {
            foreach ($dirContent As $content) {
                if (!in_array($content, $ignoreArr)) {
                    $thisFile = "$thisDir/$content";
                    if (is_file(@$thisFile)) {
                        scan_file($thisFile);
                    } else {
                        $toResolve[] = $thisFile;
                    }
                }
            }
        }
    }
    
}

function scan_file($path)
{
    global $ext, $patterns, $count, $total_results, $FileNames;
    $dateformat = "d F Y - H:i:s ";
    
    if (in_array(pathinfo($path, PATHINFO_EXTENSION), $ext) && filesize($path) && !stripos($path, 'malware-scanner.php')) {
        
		// Suspicious Filename case
        if ($malic_file_descr = array_search(pathinfo($path, PATHINFO_BASENAME), $FileNames)) {
            echo '<tr>
                    <td>' . basename($path) . '</td>
                    <td>Suspicious Filename</td>
                    <td> - </td>
					<td>' . date($dateformat, filemtime($path)) . '</td>
                    <td>
						';
						$permissions = substr(sprintf('%o', fileperms($path)), -4);
						if (intval($permissions) == 777) {
							echo '<font color="red"><b>' . $permissions . '</b></font>';
						} else if (intval($permissions) == 644) {
							echo '<font color="green">' . $permissions . '</font>';
						} else {
							echo '<font color="orange">' . $permissions . '</font>';
						}
						echo '
					</td>
                    <td><a href="' . $path . '" target="_blank">' . $path . '</a></td>
					<td>' . HumanReadableFilesize($path) . '</td>
					<td>' . md5_file($path) . '</td>
					<td></td>
                    <td>
						<a href="?ignore=' . basename($path) . '" class="btn btn-flat btn-danger">
							<i class="fa fa-ban"></i> Ignore
						</a>
					</td>
                  </tr>';
        }
        
        if (!($content = file_get_contents($path))) {
            $error = 'Could not check ' . $path;
        } else {
            
			// String and Patterns case
            foreach ($patterns As $pattern) {
                if (is_array($pattern)) {
                    preg_match_all('#' . $pattern[0] . '#isS', $content, $found, PREG_OFFSET_CAPTURE);
                } else {
                    preg_match_all('#' . $pattern . '#isS', $content, $found, PREG_OFFSET_CAPTURE);
                }
                $all_results   = $found[0];
                $results_count = count($all_results);
                $total_results += $results_count;
                if (!empty($all_results)) {
                    $count++;
					
					// Suspicious patterns case
                    if (is_array($pattern)) {
                        echo '<tr>
                         <td>' . basename($path) . '</td>
                         <td><font color="red"><i>' . $pattern[1] . '</i></font></td>
                         <td>' . $results_count . '</td>
						 <td>' . date($dateformat, filemtime($path)) . '</td>
                         <td>
							';
							$permissions = substr(sprintf('%o', fileperms($path)), -4);
							if (intval($permissions) == 777) {
								echo '<font color="red"><b>' . $permissions . '</b></font>';
							} else if (intval($permissions) == 644) {
								echo '<font color="green">' . $permissions . '</font>';
							} else {
								echo '<font color="orange">' . $permissions . '</font>';
							}
							echo '
						 </td>
                         <td>' . date($dateformat, fileatime($path)) . '</td>
						 <td><a href="' . $path . '" target="_blank">' . $path . '</a></td>
						 <td>' . HumanReadableFilesize($path) . '</td>
						 <td>' . md5_file($path) . '</td>
						 <td>
							' . $pattern[2] . '<br />
							';
							foreach ($all_results as $match) {
								echo '<span class="offset">Line #', calculate_line_number($match[1], $content), '</span>', "<pre>... " . htmlentities(substr($content, $match[1], 200), ENT_QUOTES) . " ...</pre>\n";
							}
							echo '
						 </td>
                         <td>
							<a href="?ignore=' . basename($path) . '" class="btn btn-flat btn-danger">
								<i class="fa fa-ban"></i> Ignore
							</a>
						 </td>
                        ';
						
					// Suspicious strings case
                    } else {
                        echo '<tr>
                         <td>' . basename($path) . '</td>
                         <td><font color="red"><i>' . $pattern . '</i></font></td>
                         <td>' . $results_count . '</td>
						 <td>' . date($dateformat, filemtime($path)) . '</td>
                         <td>
							';
							$permissions = substr(sprintf('%o', fileperms($path)), -4);
							if (intval($permissions) == 777) {
								echo '<font color="red"><b>' . $permissions . '</b></font>';
							} else if (intval($permissions) == 644) {
								echo '<font color="green">' . $permissions . '</font>';
							} else {
								echo '<font color="orange">' . $permissions . '</font>';
							}
							echo '
						 </td>
						 <td>' . date($dateformat, fileatime($path)) . '</td>
						 <td><a href="' . $path . '" target="_blank">' . $path . '</a></td>
						 <td>' . HumanReadableFilesize($path) . '</td>
						 <td>' . md5_file($path) . '</td>
						 <td>
							Suspicious string used: ' . $pattern . '<br />
							';
							foreach ($all_results as $match) {
								echo '<span class="offset">Line #', calculate_line_number($match[1], $content), '</span>', "<pre>... " . htmlentities(substr($content, $match[1], 200), ENT_QUOTES) . " ...</pre>\n";
							}
							echo '
						 </td>
                         <td>
							<a href="?ignore=' . basename($path) . '" class="btn btn-flat btn-danger">
								<i class="fa fa-ban"></i> Ignore
							</a>
						 </td>
                        ';
                    }
                    echo '
                    </tr>
                    ';
                }
            }
            unset($content);
        }
    }
}


function calculate_line_number($offset, $file_content)
{
    @list($first_part) = str_split($file_content, $offset);
    $line_nr = strlen($first_part) - strlen(str_replace("\n", "", $first_part)) + 1;
    return $line_nr;
}
?>
                                    
                                    <table id="dt-basic" class="table table-striped table-bordered table-hover cell-border" cellspacing="0" width="100%">
						            <thead> 
										<tr>
										  <th>File Name</th>
						                  <th>Malware Type</th>
										  <th>Occurences</th>
										  <th>Last Modified</th>
										  <th>Permissions</th>
										  <th class="none">Last Accessed: </th>
										  <th class="none">Path: </th>
										  <th class="none">Size: </th>
										  <th class="none">MD5 Hash: </th>
										  <th class="none">Threat Description: </th>
										  <th>Actions</th>
						                </tr>
									</thead>
                                   <tbody>
<?php
$before = microtime(true);
get_filelist($directory);
?>
						            </tbody>
									</table>
<?php
$after     = microtime(true);
$totaltime = mb_substr(($after - $before), 0, 4);
echo 'The scan found <strong>', $total_results, ' suspicious malware code spots</strong> in <u>', $count, ' different files</u>!<br/>';
echo 'Scanning time was <strong>' . $totaltime . ' seconds</strong> <br>';
}
?>
                                                
                            
                        </div>
                     </div>
                </div>
				</div>
                    
				</div>
				<!--===================================================-->
				<!--End page content-->


			</div>
			<!--===================================================-->
			<!--END CONTENT CONTAINER-->

<script>
$(document).ready(function() {

	$('#dt-basic').dataTable( {
		"responsive": true,
		dom: 'Bfrtip',
		buttons: [
            'excelHtml5',
            'csvHtml5',
            'pdfHtml5'
        ],
		"language": {
			"paginate": {
			  "previous": '<i class="fa fa-angle-left"></i>',
			  "next": '<i class="fa fa-angle-right"></i>'
			}
		}
	} );
} );
</script>    
<?php
footer();
?>